function trim(cadena){
	for(jj=0; jj<cadena.length; ){
		if(cadena.charAt(jj)==" ")
			cadena=cadena.substring(jj+1, cadena.length);
		else
			break;
	}

	for(jj=cadena.length-1; jj>=0; jj=cadena.length-1){
		if(cadena.charAt(jj)==" ")
			cadena=cadena.substring(0,jj);
		else
			break;
	}
	
	return cadena;
}


//----------  Funciones para validaciones de numeros : Inicio
function poner2decimales(numForm, numText){
	Formatear(numForm, numText, 'N');
	var valor = document[numForm].elements[numText].value;
	if (valor.indexOf(',')==-1 && valor!='' ){
		document[numForm].elements[numText].value = document[numForm].elements[numText].value + ",00";
	}else if (valor.indexOf(',')==(valor.length-2) ){
		document[numForm].elements[numText].value = document[numForm].elements[numText].value + "0";
	}else if (valor.indexOf(',')==(valor.length-1) && valor!=''){
		document[numForm].elements[numText].value = document[numForm].elements[numText].value + "00";	
	}else if (valor.indexOf(',')!=(valor.length-3) && valor!=''){
		document[numForm].elements[numText].value = valor.substring(0, valor.indexOf(',')+3);
	}
}

function Formatear( numForm, numText, cero){
    FormatearObjeto(document[numForm].elements[numText], cero);
}

function FormatearObjeto(fmtObject, cero){
	desFormatearObjecto(fmtObject);				
	fmtObject.value = trim (fmtObject.value);			
	var numero  = (fmtObject.value).toString();
	var aux     = new String();
	var entera  = new String();
	var decimal = new String();
	var finales = new String();
	var final1  = new String();
	var fin     = false;
	var primera = true;
	var esCero  = true;
	var resto   = new String();
	//quita los ceros por delante:
	if (numero == ""){
		if (cero == "S"){ 
			fmtObject.value = "0";
		}else{ 
			fmtObject.value = "";
		}
	}else{
		while(esCero){
			if (numero.charAt(0) == '0') {
				if (numero.length == 1){
					numero = '0';
					esCero = false;
				}else{
					numero = numero.substring(1, numero.length);
				}
			}else{
				if (numero.charAt( 0) == ','){
					numero = '0' + numero;
				}
				esCero = false;
			}		
		}
		//le quita las letras:
		i = 0;
		primera = true;
		while(i < numero.length){
			if ( ( ( numero.charCodeAt(i) < 48 ) || (numero.charCodeAt(i) > 57 ) ) && ( numero.charCodeAt(i) != 44 ) && ( numero.charCodeAt( i) != 46 )){
				return;
			}
			if (numero.charCodeAt(i) == 44){
				if (primera) {
					primera = false;
				}else{
					return;
				}    
			}
			i++;
		}
		//le quita los puntos que ya tenga puestos
		while (numero.length > 0 && fin == false){
			if (numero.indexOf('.') != -1) {	
				var indice = numero.indexOf('.');
				aux = aux.concat(numero.substring(0, indice));								
				numero = numero.substring(indice + 1, numero.length);
			}else{
				aux = aux.concat(numero);
				fin = true;
			}
		}
		//guardamos los decimales:
		var indice = aux.indexOf(',');
		if (indice!=-1) {
			entera = aux.substring(0, indice);
			decimal = aux.substring(indice, aux.length);	
		}else{
			entera  = aux;
			decimal = "";
		}		
		//ponemos los puntos de los miles:
		while(entera.length > 3){
			var longitud = entera.length;
			resto   = entera.substring(longitud-3, longitud);
			entera  = entera.substring(0, entera.lastIndexOf(resto));
			finales = "." + resto + finales;
		}
	   
		final1 = final1.concat(entera, finales, decimal);
		fmtObject.value = final1;
	}	
}

function desFormatearObjecto(fmtObject){
	numero = (fmtObject.value).toString();
	var aux = new String();
	var fin = false;
	var esCero = true;
		
	if (numero!='0'){
		while (esCero){
			if (numero.charAt( 0) == '0'){
				if (numero.length == 1){
					numero = '0';
					esCero = false;
				}else{
					numero = numero.substring( 1, numero.length);
				}
			}else{
				if (numero.charAt( 0) == ','){
					numero = '0' + numero;
				}
				esCero = false;
			}		
		}
		while ((numero.length > 0) && !fin){
			if (numero.indexOf('.') != -1 ){	
				var indice = numero.indexOf('.');
				aux = aux.concat(numero.substring(0, indice));								
				numero = numero.substring(indice + 1, numero.length);
			}else{
				aux = aux.concat(numero);
				fin=true;
			}
		}
		fmtObject.value = aux;
	}
}

//----------  Funciones para validaciones de numeros : Fin



//---------- Funciones para la validacin del CIF/NIF : Inicio

function validateDNI(dni){
	if (dni.length != 9) return false;
	
	if (dni.substr(0,1).toUpperCase() == "X")
		dni = dni.substr(1);
	
	letra = dni.substr(dni.length-1, 1).toUpperCase();
	dni = dni.substr(0,dni.length-1);
	
	return ( "TRWAGMYFPDXBNJZSQVHLCKE".substr((dni % 23), 1) == letra);
}


// La funcin recibe el CIF completo: A58818501
 function ValidaCIF(cif){
	if (cif.length != 9)
		return false;
	
	letra = cif.substr(0,1).toUpperCase();
	
	/* Comentarios a fecha 17/02/2017
	Quitada la "X", ya que se va a tratar como persona fsica, y para estos CIF extranjeros la nica 
	comprobacin que se va a realizar es la longitud de 9 caracteres.
	if ("ABCDEFGHPQSKLMX".indexOf(letra) == -1)
	*/
	//if ("ABCDEFGHPQSKLM".indexOf(letra) == -1) p06b comentado a fecha 17/02/2017
	//if ("ABCDEFGHJNPQRSUVW".indexOf(letra) == -1) t07b a fecha 17/02/2017
	if ("ABCDEGHFJNPQRSUVW".indexOf(letra) == -1)
		return false;
	
	//Por aqu ya no va a entrar nunca porque la letra "X" para Jurdicas no se va a dar por vlida.
	if (letra == "X")
		return validateDNI(cif);
		
	numControl = cif.substr(8,1);
	cif = cif.substr(1,7);
	
	if (validarEntero(cif) == ""){
		//alert ("El CIF es incorrecto");
		return;
	}
	
	suma = (cif.substr(1,1) * 1) + (cif.substr(3,1) * 1) + (cif.substr(5,1) * 1);
	
	for (i=0;i<=6;i=i+2){
		numero = cif.substr(i,1) * 2;
		suma = suma + numero % 10;
		suma = suma + (Math.floor(numero / 10));
	}
	
	control = 10 - (suma % 10);
	//if ((letra == "P")||(letra == "K")||(letra == "Q")||(letra == "S")){  p06b comentado a fecha 17/02/2017
	//if ((letra == "P")||(letra == "K")||(letra == "Q")||(letra == "S")||(letra == "N")||(letra == "R")||(letra == "W")){  t07b a fecha 17/02/2017
	if ("FJNPQRSUVW".indexOf(letra) != -1){
		return ( numControl == String.fromCharCode((64 + control)));
	}else{
		if (control == 10) control = 0;
		return ( numControl == control );
	}
}

function esCorrectaLetraCIF(letra){
	/* Comentarios a fecha 17/02/2017
	//Quitada la "X", ya que se va a tratar como persona fsica, y para estos CIF extranjeros la nica 
	//comprobacin que se va a realizar es la longitud de 9 caracteres.
	//if ("ABCDEFGHPQSKLMX".indexOf(letra) == -1){
	*/
	// if ("ABCDEFGHPQSKLM".indexOf(letra) == -1){ p06b comentado a fecha 17/02/2017
	// if ("ABCDEGHFJ KLM NPQRSUVW".indexOf(letra) == -1){ documento 2008
	if ("ABCDEGHFJNPQRSUVW".indexOf(letra) == -1){
		return false;
	}
	return true;
}

// La funcin recibe el CIF completo: A58818501
 function calculaDigitoControl(cif){
	letra = cif.substr(0,1).toUpperCase();
	
	/* Comentarios a fecha 17/02/2017
	//Quitada la "X", ya que se va a tratar como persona fsica, y para estos CIF extranjeros la nica 
	//comprobacin que se va a realizar es la longitud de 9 caracteres.
	//if ("ABCDEFGHPQSKLMX".indexOf(letra) == -1){
	*/
	//if ("ABCDEFGHPQSKLM".indexOf(letra) == -1){ p06b comentado a fecha 17/02/2017
	// if ("ABCDEGHFJ KLM NPQRSUVW".indexOf(letra) == -1){ documento 2008
	if ("ABCDEGHFJNPQRSUVW".indexOf(letra) == -1){
		//alert("La letra del Cif es incorrecta");
		return;
	}
	
	cif = cif.substr(1,7);
	if (validarEntero(cif) == ""){
		//alert ("El CIF es incorrecto");
		return;
	}
	
	suma = (cif.substr(1,1) * 1) + (cif.substr(3,1) * 1) + (cif.substr(5,1) * 1);
	
	for (i=0;i<=6;i=i+2){
		numero = cif.substr(i,1) * 2;
		suma = suma + numero % 10;
		suma = suma + (Math.floor(numero / 10));
	}
	
	control = 10 - (suma % 10);
	//if ((letra == "P")||(letra == "K")||(letra == "Q")||(letra == "S")){  p06b comentado a fecha 17/02/2017
	//if ((letra == "P")||(letra == "K")||(letra == "Q")||(letra == "S")||(letra == "N")||(letra == "R")||(letra == "W")){  t07b a fecha 17/02/2017
	if ("FJNPQRSUVW".indexOf(letra) != -1){
		return String.fromCharCode(64 + control);
	}else{
		if (control == 10) control = 0;
		return control;
	}
}


/* Tamao incorrecto del dni*/
function comprobar8numeros(nif){
	var correcto = false;	
	if(nif.length == 9) {		
		dni=nif.substring(0,nif.length-1);	//del NIF nos quedamos con el DNI
	} else {		
		dni=nif;
	}

	//expresion regular, comprobar que en el DNI vengan 8 numeros.
	var b=/^\d{8}$/;
	//devuelve verdadero si validacion OK, y falso en caso contrario
	if(b.test(dni)){
		dni=parseInt(dni,10);//parseInt en base 10
		if (validarEntero(dni) == ""){
			correcto = false
		//}else if ((dni > 99999999)||(dni < 10000000)) {
		}else if (dni > 99999999) {
			correcto = false; 
		}else {
			correcto = true;
		}	
	}else{
		correcto = false;
	}
	
	return correcto;
}

/* Dado un dni de 8 cifras, devuelve la letra */
function letraNifCorrecta(nif){
	letras = new Array();
	letras[0]  = "T";
	letras[1]  = "R";
	letras[2]  = "W";
	letras[3]  = "A";
	letras[4]  = "G";
	letras[5]  = "M";
	letras[6]  = "Y";
	letras[7]  = "F";
	letras[8]  = "P";
	letras[9]  = "D";
	letras[10] = "X";
	letras[11] = "B";
	letras[12] = "N";
	letras[13] = "J";
	letras[14] = "Z";
	letras[15] = "S";
	letras[16] = "Q";
	letras[17] = "V";
	letras[18] = "H";
	letras[19] = "L";
	letras[20] = "C";
	letras[21] = "K";
	letras[22] = "E";
	
	//dado un NIF te devuelve si es o no correcto
	txtError = "";			//texto que se mostrara en caso de error
	ok = true;				//variable booleana que controla si hay algn error
	dni=nif;	//del NIF nos quedamos con el DNI
	
	dni=parseInt(dni,10);					//al convertirlo a entero, le quitamos los ceros de la izquierda	
	letraCorrecta = letras[ dni % 23];	//la letra que debera ser para ese DNI
	
	return letraCorrecta;
}


function validarEntero(valor){
      //intento convertir a entero. 
      //si era un entero no le afecta, si no lo era lo intenta convertir       
       valor2 = parseInt(valor,10);

      //Compruebo si es un valor numrico 
      //if (isNaN(valor2)) {      
      if (isNaN(valor)) {
         //entonces (no es numero) devuelvo el valor cadena vacia     
         return "" ;
      }else{ 
         //En caso contrario (Si era un nmero) devuelvo el valor 
         return valor; 
      } 
} 

//---------- Funciones para la validacin del CIF/NIF : Fin


//Funcion para validar la longitud de los textarea
	function imposeMaxLength(Object, MaxLen){
	  return (Object.value.length <= MaxLen);
	}


//Funcion que devuelve el valor de la opcion seleccionada en el radio
	function getCheckedValue(radioObj) {
		if(!radioObj)
			return "";
		var radioLength = radioObj.length;
		if(radioLength == undefined)
			if(radioObj.checked)
				return radioObj.value;
			else
				return "";
		for(var i = 0; i < radioLength; i++) {
			if(radioObj[i].checked) {
				return radioObj[i].value;
			}
		}
		return "";
	}









